<?php
session_start();
require_once __DIR__ . '/../api/config.php';

if (empty($_SESSION['auth'])) {
    header("Location: index.php");
    exit;
}

$deviceId = $SMS_CONFIG['device_id'];
$qfile = sms_queue_file($deviceId);

$queueCount = 0;
if (file_exists($qfile)) {
    $data = json_decode(file_get_contents($qfile), true);
    if (!empty($data['jobs'])) $queueCount = count($data['jobs']);
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
<meta charset="UTF-8">
<title>SMS Gateway Yönetim Paneli</title>
<style>
    body {
        margin: 0;
        background: #0f172a;
        font-family: "Segoe UI", Arial, sans-serif;
        color: #e2e8f0;
        padding: 0;
    }
    .header {
        background: #1e293b;
        padding: 20px 30px;
        font-size: 22px;
        font-weight: 600;
        color: #fff;
        box-shadow: 0 2px 8px #0005;
    }
    .container {
        padding: 30px;
        max-width: 900px;
        margin: auto;
    }
    .card {
        background: #1e293b;
        padding: 20px;
        border-radius: 12px;
        box-shadow: 0 0 15px #0004;
        margin-bottom: 25px;
    }
    .card h3 {
        margin-top: 0;
        margin-bottom: 10px;
        color: #60a5fa;
    }
    .value {
        font-size: 22px;
        font-weight: bold;
        color: #f8fafc;
        margin-bottom: 10px;
    }
    .badge {
        display: inline-block;
        padding: 5px 12px;
        border-radius: 8px;
        font-size: 15px;
        font-weight: 600;
    }
    .badge-green {
        background: #16a34a;
        color: white;
    }
    .badge-red {
        background: #ef4444;
        color: white;
    }
    .badge-yellow {
        background: #eab308;
        color: black;
    }
    .links a {
        color: #93c5fd;
        text-decoration: none;
        font-size: 16px;
        margin-right: 15px;
    }
    .links a:hover {
        text-decoration: underline;
    }
</style>
</head>
<body>

<div class="header">📡 SMS Gateway Yönetim Paneli</div>

<div class="container">

    <!-- API Bilgisi -->
    <div class="card">
        <h3>API Bilgisi</h3>
        <div class="value"><?= $SMS_CONFIG['api_key'] ?></div>
        <div class="badge badge-green">Aktif</div>
    </div>

    <!-- Cihaz Bilgisi -->
    <div class="card">
        <h3>Cihaz (Telefon) Durumu</h3>
        <div class="value">Cihaz ID: <?= $deviceId ?></div>

        <div id="deviceStatus">
            <span class="badge badge-red">🔴 Bağlı Değil</span>
        </div>

        <small id="lastSeenText" style="color:#94a3b8;display:block;margin-top:10px;">Son bağlantı: -</small>
    </div>

    <!-- Kuyruk Bilgisi -->
    <div class="card">
        <h3>SMS Kuyruğu</h3>
        <div class="value"><?= $queueCount ?> adet SMS bekliyor</div>

        <?php if ($queueCount > 0): ?>
            <div class="badge badge-yellow">İşlem Bekliyor</div>
        <?php else: ?>
            <div class="badge badge-green">Boş</div>
        <?php endif; ?>
    </div>

    <!-- Linkler -->
    <div class="card">
        <h3>İşlemler</h3>
        <div class="links">
            <a href="logs.php">📝 Logları Gör</a>
            <a href="logout.php">🚪 Çıkış Yap</a>
        </div>
    </div>

</div>

<script>
function updateDeviceStatus() {
    fetch("../api/device_status.php")
        .then(r => r.json())
        .then(data => {
            let box = document.getElementById("deviceStatus");
            let text = document.getElementById("lastSeenText");

            if (data.status === "online") {
                box.innerHTML = '<span class="badge badge-green">🟢 Bağlı</span>';
            } else {
                box.innerHTML = '<span class="badge badge-red">🔴 Bağlı Değil</span>';
            }

            if (data.lastSeen > 0) {
                text.innerText = "Son bağlantı: " + data.lastSeenAgo + " saniye önce";
            } else {
                text.innerText = "Son bağlantı: hiç yok";
            }
        })
        .catch(err => console.log(err));
}

// Her 5 saniyede bir güncelle
setInterval(updateDeviceStatus, 5000);

// Sayfa açılır açılmaz çalıştır
updateDeviceStatus();
</script>

</body>
</html>
